import { defineIntegration } from '@sentry/core';
import { getIPC } from '../ipc.js';

const eventLoopBlockIntegration = defineIntegration((options) => {
    const anrThreshold = options?.threshold ?? 1000;
    const pollInterval = options?.pollInterval || anrThreshold / 2;
    return {
        name: 'EventLoopBlockRenderer',
        setup() {
            const config = {
                pollInterval,
                anrThreshold,
                captureStackTrace: true,
                ...options,
            };
            const ipc = getIPC();
            // eslint-disable-next-line no-restricted-globals
            ipc.sendStatus({ status: document.visibilityState, config });
            setInterval(() => {
                ipc.sendStatus({ status: 'alive', config });
            }, config.pollInterval);
        },
    };
});

export { eventLoopBlockIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/8cd6f62c4c264240eb1925773707665d0f5b25e0/node_modules/@sentry/electron/esm/renderer/integrations/event-loop-block.js.map
