/** Ways to communicate between the renderer and main process  */
var IPCMode;
(function (IPCMode) {
    /** Configures Electron IPC to receive messages from renderers */
    IPCMode[IPCMode["Classic"] = 1] = "Classic";
    /** Configures Electron protocol module to receive messages from renderers */
    IPCMode[IPCMode["Protocol"] = 2] = "Protocol";
    /**
     * Configures both methods for best compatibility.
     *
     * Renderers favour IPC but fall back to protocol if IPC has not
     * been configured in a preload script
     */
    IPCMode[IPCMode["Both"] = 3] = "Both";
})(IPCMode || (IPCMode = {}));
const PROTOCOL_SCHEME = 'sentry-ipc';
var IPCChannel;
(function (IPCChannel) {
    /** IPC to check main process is listening */
    IPCChannel["RENDERER_START"] = "sentry-electron.renderer-start";
    /** IPC to pass scope changes to main process. */
    IPCChannel["SCOPE"] = "sentry-electron.scope";
    /** IPC to pass envelopes to the main process. */
    IPCChannel["ENVELOPE"] = "sentry-electron.envelope";
    /** IPC to pass renderer status updates */
    IPCChannel["STATUS"] = "sentry-electron.status";
    /** IPC to pass structured log messages */
    IPCChannel["STRUCTURED_LOG"] = "sentry-electron.structured-log";
})(IPCChannel || (IPCChannel = {}));
const RENDERER_ID_HEADER = 'sentry-electron-renderer-id';
const UTILITY_PROCESS_MAGIC_MESSAGE_KEY = '__sentry_message_port_message__';
/** Does the message look like the magic message */
function isMagicMessage(msg) {
    return !!(msg && typeof msg === 'object' && UTILITY_PROCESS_MAGIC_MESSAGE_KEY in msg);
}
/** Get the magic message to send to the utility process */
function getMagicMessage() {
    return { [UTILITY_PROCESS_MAGIC_MESSAGE_KEY]: true };
}

export { IPCChannel, IPCMode, PROTOCOL_SCHEME, RENDERER_ID_HEADER, getMagicMessage, isMagicMessage };//# sourceMappingURL=http://go/sourcemap/sourcemaps/8cd6f62c4c264240eb1925773707665d0f5b25e0/node_modules/@sentry/electron/esm/common/ipc.js.map
