import { Observable, operate, COMPLETE_NOTIFICATION, errorNotification, nextNotification } from '../Observable.js';
export function materialize() {
    return (source) => new Observable((destination) => {
        source.subscribe(operate({
            destination,
            next: (value) => {
                destination.next(nextNotification(value));
            },
            error: (error) => {
                destination.next(errorNotification(error));
                destination.complete();
            },
            complete: () => {
                destination.next(COMPLETE_NOTIFICATION);
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/86d7e0c1a66a0a5f7e32cdbaf9b4bfbaf20ddaf0/node_modules/rxjs/dist/esm/internal/operators/materialize.js.map