import { asyncScheduler } from '../scheduler/async.js';
import { Observable, operate } from '../Observable.js';
import { executeSchedule } from '../util/executeSchedule.js';
export function debounceTime(dueTime, scheduler = asyncScheduler) {
    return (source) => new Observable((destination) => {
        let lastValue;
        let activeTask;
        source.subscribe(operate({
            destination,
            next: (value) => {
                lastValue = value;
                activeTask?.unsubscribe();
                activeTask = executeSchedule(destination, scheduler, () => {
                    activeTask = undefined;
                    const v = lastValue;
                    lastValue = null;
                    destination.next(v);
                }, dueTime);
            },
            complete: () => {
                if (activeTask) {
                    destination.next(lastValue);
                }
                destination.complete();
            },
            finalize: () => {
                lastValue = activeTask = null;
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/86d7e0c1a66a0a5f7e32cdbaf9b4bfbaf20ddaf0/node_modules/rxjs/dist/esm/internal/operators/debounceTime.js.map