"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.using = void 0;
const Observable_js_1 = require("../Observable.js");
const empty_js_1 = require("./empty.js");
function using(resourceFactory, observableFactory) {
    return new Observable_js_1.Observable((subscriber) => {
        const resource = resourceFactory();
        const result = observableFactory(resource);
        const source = result ? (0, Observable_js_1.from)(result) : empty_js_1.EMPTY;
        source.subscribe(subscriber);
        return () => {
            if (resource) {
                resource.unsubscribe();
            }
        };
    });
}
exports.using = using;//# sourceMappingURL=http://go/sourcemap/sourcemaps/86d7e0c1a66a0a5f7e32cdbaf9b4bfbaf20ddaf0/node_modules/rxjs/dist/cjs/internal/observable/using.js.map