import { switchMap } from './switchMap.js';
import { Observable, operate } from '../Observable.js';
export function switchScan(accumulator, seed) {
    return (source) => new Observable((destination) => {
        let state = seed;
        switchMap((value, index) => accumulator(state, value, index))(source).subscribe(operate({
            destination,
            next: (innerValue) => {
                state = innerValue;
                destination.next(innerValue);
            },
        }));
        return () => {
            state = null;
        };
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/86d7e0c1a66a0a5f7e32cdbaf9b4bfbaf20ddaf0/node_modules/rxjs/dist/esm/internal/operators/switchScan.js.map