Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const http = require('./integrations/http.js');
const nodeFetch = require('./integrations/node-fetch.js');
const fs = require('./integrations/fs.js');
const express = require('./integrations/tracing/express.js');
const index = require('./integrations/tracing/fastify/index.js');
const graphql = require('./integrations/tracing/graphql.js');
const kafka = require('./integrations/tracing/kafka.js');
const lrumemoizer = require('./integrations/tracing/lrumemoizer.js');
const mongo = require('./integrations/tracing/mongo.js');
const mongoose = require('./integrations/tracing/mongoose.js');
const mysql = require('./integrations/tracing/mysql.js');
const mysql2 = require('./integrations/tracing/mysql2.js');
const redis = require('./integrations/tracing/redis.js');
const postgres = require('./integrations/tracing/postgres.js');
const postgresjs = require('./integrations/tracing/postgresjs.js');
const prisma = require('./integrations/tracing/prisma.js');
const index$1 = require('./integrations/tracing/hapi/index.js');
const index$2 = require('./integrations/tracing/hono/index.js');
const koa = require('./integrations/tracing/koa.js');
const connect = require('./integrations/tracing/connect.js');
const knex = require('./integrations/tracing/knex.js');
const tedious = require('./integrations/tracing/tedious.js');
const genericPool = require('./integrations/tracing/genericPool.js');
const dataloader = require('./integrations/tracing/dataloader.js');
const amqplib = require('./integrations/tracing/amqplib.js');
const index$3 = require('./integrations/tracing/vercelai/index.js');
const index$4 = require('./integrations/tracing/openai/index.js');
const index$5 = require('./integrations/tracing/anthropic-ai/index.js');
const index$6 = require('./integrations/tracing/google-genai/index.js');
const index$7 = require('./integrations/tracing/langchain/index.js');
const launchDarkly = require('./integrations/featureFlagShims/launchDarkly.js');
const openFeature = require('./integrations/featureFlagShims/openFeature.js');
const statsig = require('./integrations/featureFlagShims/statsig.js');
const unleash = require('./integrations/featureFlagShims/unleash.js');
const growthbook = require('./integrations/featureFlagShims/growthbook.js');
const firebase = require('./integrations/tracing/firebase/firebase.js');
const index$8 = require('./sdk/index.js');
const initOtel = require('./sdk/initOtel.js');
const index$9 = require('./integrations/tracing/index.js');
const opentelemetry = require('@sentry/opentelemetry');
const core = require('@sentry/core');
const nodeCore = require('@sentry/node-core');



exports.httpIntegration = http.httpIntegration;
exports.nativeNodeFetchIntegration = nodeFetch.nativeNodeFetchIntegration;
exports.fsIntegration = fs.fsIntegration;
exports.expressErrorHandler = express.expressErrorHandler;
exports.expressIntegration = express.expressIntegration;
exports.setupExpressErrorHandler = express.setupExpressErrorHandler;
exports.fastifyIntegration = index.fastifyIntegration;
exports.setupFastifyErrorHandler = index.setupFastifyErrorHandler;
exports.graphqlIntegration = graphql.graphqlIntegration;
exports.kafkaIntegration = kafka.kafkaIntegration;
exports.lruMemoizerIntegration = lrumemoizer.lruMemoizerIntegration;
exports.mongoIntegration = mongo.mongoIntegration;
exports.mongooseIntegration = mongoose.mongooseIntegration;
exports.mysqlIntegration = mysql.mysqlIntegration;
exports.mysql2Integration = mysql2.mysql2Integration;
exports.redisIntegration = redis.redisIntegration;
exports.postgresIntegration = postgres.postgresIntegration;
exports.postgresJsIntegration = postgresjs.postgresJsIntegration;
exports.prismaIntegration = prisma.prismaIntegration;
exports.hapiIntegration = index$1.hapiIntegration;
exports.setupHapiErrorHandler = index$1.setupHapiErrorHandler;
exports.honoIntegration = index$2.honoIntegration;
exports.setupHonoErrorHandler = index$2.setupHonoErrorHandler;
exports.koaIntegration = koa.koaIntegration;
exports.setupKoaErrorHandler = koa.setupKoaErrorHandler;
exports.connectIntegration = connect.connectIntegration;
exports.setupConnectErrorHandler = connect.setupConnectErrorHandler;
exports.knexIntegration = knex.knexIntegration;
exports.tediousIntegration = tedious.tediousIntegration;
exports.genericPoolIntegration = genericPool.genericPoolIntegration;
exports.dataloaderIntegration = dataloader.dataloaderIntegration;
exports.amqplibIntegration = amqplib.amqplibIntegration;
exports.vercelAIIntegration = index$3.vercelAIIntegration;
exports.openAIIntegration = index$4.openAIIntegration;
exports.anthropicAIIntegration = index$5.anthropicAIIntegration;
exports.googleGenAIIntegration = index$6.googleGenAIIntegration;
exports.langChainIntegration = index$7.langChainIntegration;
exports.buildLaunchDarklyFlagUsedHandler = launchDarkly.buildLaunchDarklyFlagUsedHandlerShim;
exports.launchDarklyIntegration = launchDarkly.launchDarklyIntegrationShim;
exports.OpenFeatureIntegrationHook = openFeature.OpenFeatureIntegrationHookShim;
exports.openFeatureIntegration = openFeature.openFeatureIntegrationShim;
exports.statsigIntegration = statsig.statsigIntegrationShim;
exports.unleashIntegration = unleash.unleashIntegrationShim;
exports.growthbookIntegration = growthbook.growthbookIntegrationShim;
exports.firebaseIntegration = firebase.firebaseIntegration;
exports.getDefaultIntegrations = index$8.getDefaultIntegrations;
exports.getDefaultIntegrationsWithoutPerformance = index$8.getDefaultIntegrationsWithoutPerformance;
exports.init = index$8.init;
exports.initWithoutDefaultIntegrations = index$8.initWithoutDefaultIntegrations;
exports.initOpenTelemetry = initOtel.initOpenTelemetry;
exports.preloadOpenTelemetry = initOtel.preloadOpenTelemetry;
exports.getAutoPerformanceIntegrations = index$9.getAutoPerformanceIntegrations;
exports.setNodeAsyncContextStrategy = opentelemetry.setOpenTelemetryContextAsyncContextStrategy;
exports.SDK_VERSION = core.SDK_VERSION;
exports.SEMANTIC_ATTRIBUTE_SENTRY_OP = core.SEMANTIC_ATTRIBUTE_SENTRY_OP;
exports.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN = core.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE = core.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE = core.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addEventProcessor = core.addEventProcessor;
exports.addIntegration = core.addIntegration;
exports.captureCheckIn = core.captureCheckIn;
exports.captureConsoleIntegration = core.captureConsoleIntegration;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureFeedback = core.captureFeedback;
exports.captureMessage = core.captureMessage;
exports.captureSession = core.captureSession;
exports.close = core.close;
exports.consoleIntegration = core.consoleIntegration;
exports.consoleLoggingIntegration = core.consoleLoggingIntegration;
exports.continueTrace = core.continueTrace;
exports.createConsolaReporter = core.createConsolaReporter;
exports.createLangChainCallbackHandler = core.createLangChainCallbackHandler;
exports.createTransport = core.createTransport;
exports.dedupeIntegration = core.dedupeIntegration;
exports.endSession = core.endSession;
exports.eventFiltersIntegration = core.eventFiltersIntegration;
exports.extraErrorDataIntegration = core.extraErrorDataIntegration;
exports.featureFlagsIntegration = core.featureFlagsIntegration;
exports.flush = core.flush;
exports.functionToStringIntegration = core.functionToStringIntegration;
exports.getActiveSpan = core.getActiveSpan;
exports.getClient = core.getClient;
exports.getCurrentScope = core.getCurrentScope;
exports.getGlobalScope = core.getGlobalScope;
exports.getIsolationScope = core.getIsolationScope;
exports.getRootSpan = core.getRootSpan;
exports.getSpanDescendants = core.getSpanDescendants;
exports.getSpanStatusFromHttpCode = core.getSpanStatusFromHttpCode;
exports.getTraceData = core.getTraceData;
exports.getTraceMetaTags = core.getTraceMetaTags;
exports.httpHeadersToSpanAttributes = core.httpHeadersToSpanAttributes;
exports.inboundFiltersIntegration = core.inboundFiltersIntegration;
exports.instrumentSupabaseClient = core.instrumentSupabaseClient;
exports.isEnabled = core.isEnabled;
exports.isInitialized = core.isInitialized;
exports.lastEventId = core.lastEventId;
exports.linkedErrorsIntegration = core.linkedErrorsIntegration;
exports.parameterize = core.parameterize;
exports.profiler = core.profiler;
exports.requestDataIntegration = core.requestDataIntegration;
exports.rewriteFramesIntegration = core.rewriteFramesIntegration;
exports.setContext = core.setContext;
exports.setCurrentClient = core.setCurrentClient;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setHttpStatus = core.setHttpStatus;
exports.setMeasurement = core.setMeasurement;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.spanToBaggageHeader = core.spanToBaggageHeader;
exports.spanToJSON = core.spanToJSON;
exports.spanToTraceHeader = core.spanToTraceHeader;
exports.startInactiveSpan = core.startInactiveSpan;
exports.startNewTrace = core.startNewTrace;
exports.startSession = core.startSession;
exports.startSpan = core.startSpan;
exports.startSpanManual = core.startSpanManual;
exports.supabaseIntegration = core.supabaseIntegration;
exports.suppressTracing = core.suppressTracing;
exports.trpcMiddleware = core.trpcMiddleware;
exports.updateSpanName = core.updateSpanName;
exports.winterCGHeadersToDict = core.winterCGHeadersToDict;
exports.withActiveSpan = core.withActiveSpan;
exports.withIsolationScope = core.withIsolationScope;
exports.withMonitor = core.withMonitor;
exports.withScope = core.withScope;
exports.wrapMcpServerWithSentry = core.wrapMcpServerWithSentry;
exports.zodErrorsIntegration = core.zodErrorsIntegration;
exports.NODE_VERSION = nodeCore.NODE_VERSION;
exports.NodeClient = nodeCore.NodeClient;
exports.SentryContextManager = nodeCore.SentryContextManager;
exports.anrIntegration = nodeCore.anrIntegration;
exports.childProcessIntegration = nodeCore.childProcessIntegration;
exports.contextLinesIntegration = nodeCore.contextLinesIntegration;
exports.createGetModuleFromFilename = nodeCore.createGetModuleFromFilename;
exports.createSentryWinstonTransport = nodeCore.createSentryWinstonTransport;
exports.cron = nodeCore.cron;
exports.defaultStackParser = nodeCore.defaultStackParser;
exports.disableAnrDetectionForCallback = nodeCore.disableAnrDetectionForCallback;
exports.generateInstrumentOnce = nodeCore.generateInstrumentOnce;
exports.getSentryRelease = nodeCore.getSentryRelease;
exports.httpServerIntegration = nodeCore.httpServerIntegration;
exports.httpServerSpansIntegration = nodeCore.httpServerSpansIntegration;
exports.localVariablesIntegration = nodeCore.localVariablesIntegration;
exports.logger = nodeCore.logger;
exports.makeNodeTransport = nodeCore.makeNodeTransport;
exports.metrics = nodeCore.metrics;
exports.modulesIntegration = nodeCore.modulesIntegration;
exports.nodeContextIntegration = nodeCore.nodeContextIntegration;
exports.onUncaughtExceptionIntegration = nodeCore.onUncaughtExceptionIntegration;
exports.onUnhandledRejectionIntegration = nodeCore.onUnhandledRejectionIntegration;
exports.pinoIntegration = nodeCore.pinoIntegration;
exports.spotlightIntegration = nodeCore.spotlightIntegration;
exports.systemErrorIntegration = nodeCore.systemErrorIntegration;
exports.validateOpenTelemetrySetup = nodeCore.validateOpenTelemetrySetup;//# sourceMappingURL=http://go/sourcemap/sourcemaps/86d7e0c1a66a0a5f7e32cdbaf9b4bfbaf20ddaf0/node_modules/@sentry/node/build/cjs/index.js.map
