import { switchMap } from './switchMap.js';
import { Observable, operate } from '../Observable.js';
export function switchScan(accumulator, seed) {
    return (source) => new Observable((destination) => {
        let state = seed;
        switchMap((value, index) => accumulator(state, value, index))(source).subscribe(operate({
            destination,
            next: (innerValue) => {
                state = innerValue;
                destination.next(innerValue);
            },
        }));
        return () => {
            state = null;
        };
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/8454b7b9b99c4ba5934f0c6d7738f99c4d2c2d80/node_modules/rxjs/dist/esm/internal/operators/switchScan.js.map