import { withScope, getTraceContextFromScope } from '../currentScopes.js';
import { getDynamicSamplingContextFromSpan, getDynamicSamplingContextFromScope } from '../tracing/dynamicSamplingContext.js';
import { getActiveSpan, spanToTraceContext } from './spanUtils.js';

/** Extract trace information from scope */
function _getTraceInfoFromScope(
  client,
  scope,
) {
  if (!scope) {
    return [undefined, undefined];
  }

  return withScope(scope, () => {
    const span = getActiveSpan();
    const traceContext = span ? spanToTraceContext(span) : getTraceContextFromScope(scope);
    const dynamicSamplingContext = span
      ? getDynamicSamplingContextFromSpan(span)
      : getDynamicSamplingContextFromScope(client, scope);
    return [dynamicSamplingContext, traceContext];
  });
}

export { _getTraceInfoFromScope };//# sourceMappingURL=http://go/sourcemap/sourcemaps/8454b7b9b99c4ba5934f0c6d7738f99c4d2c2d80/node_modules/@sentry/core/build/esm/utils/trace-info.js.map
