import { Observable, operate } from '../Observable.js';
export function pairwise() {
    return (source) => new Observable((destination) => {
        let prev;
        let hasPrev = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                const p = prev;
                prev = value;
                hasPrev && destination.next([p, value]);
                hasPrev = true;
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/8454b7b9b99c4ba5934f0c6d7738f99c4d2c2d80/node_modules/rxjs/dist/esm/internal/operators/pairwise.js.map