Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const api = require('@opentelemetry/api');
const opentelemetry = require('@sentry/opentelemetry');

/**
 * Update the active isolation scope.
 * Should be used with caution!
 */
function setIsolationScope(isolationScope) {
  const scopes = opentelemetry.getScopesFromContext(api.context.active());
  if (scopes) {
    scopes.isolationScope = isolationScope;
  }
}

exports.setIsolationScope = setIsolationScope;//# sourceMappingURL=http://go/sourcemap/sourcemaps/8454b7b9b99c4ba5934f0c6d7738f99c4d2c2d80/node_modules/@sentry/node-core/build/cjs/sdk/scope.js.map
