import { from } from '../Observable.js';
import { mergeAll } from '../operators/mergeAll.js';
import { EMPTY } from './empty.js';
import { popNumber, popScheduler } from '../util/args.js';
import { scheduled } from '../scheduled/scheduled.js';
export function merge(...args) {
    const scheduler = popScheduler(args);
    const concurrent = popNumber(args, Infinity);
    const sources = args;
    return !sources.length
        ?
            EMPTY
        : sources.length === 1
            ?
                from(sources[0])
            :
                mergeAll(concurrent)(scheduler ? scheduled(sources, scheduler) : from(sources));
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7c2ce39981a2dd9877d57af05db98697e1c20900/node_modules/rxjs/dist/esm/internal/observable/merge.js.map