import { base58btc } from './bases/base58.js';
export async function walk({ cid, load, seen }) {
    seen = seen ?? new Set();
    const b58Cid = cid.toString(base58btc);
    if (seen.has(b58Cid)) {
        return;
    }
    const block = await load(cid);
    seen.add(b58Cid);
    if (block === null) { // the loader signals with `null` that we should skip this block
        return;
    }
    for (const [, cid] of block.links()) {
        await walk({ cid, load, seen });
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7c2ce39981a2dd9877d57af05db98697e1c20900/node_modules/multiformats/dist/src/traversal.js.map