/**
 * Takes the SDK metadata and adds the user-agent header to the transport options.
 * This ensures that the SDK sends the user-agent header with SDK name and version to
 * all requests made by the transport.
 *
 * @see https://develop.sentry.dev/sdk/overview/#user-agent
 */
function addUserAgentToTransportHeaders(options) {
  const sdkMetadata = options._metadata?.sdk;
  const sdkUserAgent =
    sdkMetadata?.name && sdkMetadata?.version ? `${sdkMetadata?.name}/${sdkMetadata?.version}` : undefined;

  options.transportOptions = {
    ...options.transportOptions,
    headers: {
      ...(sdkUserAgent && { 'user-agent': sdkUserAgent }),
      ...options.transportOptions?.headers,
    },
  };
}

export { addUserAgentToTransportHeaders };//# sourceMappingURL=http://go/sourcemap/sourcemaps/7c2ce39981a2dd9877d57af05db98697e1c20900/node_modules/@sentry/core/build/esm/transports/userAgent.js.map
