import { EMPTY } from '../observable/empty.js';
import { Observable, operate } from '../Observable.js';
export function takeLast(count) {
    return count <= 0
        ? () => EMPTY
        : (source) => new Observable((destination) => {
            let ring = new Array(count);
            let counter = 0;
            source.subscribe(operate({
                destination,
                next: (value) => {
                    ring[counter++ % count] = value;
                },
                complete: () => {
                    const start = count <= counter ? counter : 0;
                    const total = Math.min(count, counter);
                    for (let n = 0; n < total; n++) {
                        destination.next(ring[(start + n) % count]);
                    }
                    destination.complete();
                },
                finalize: () => {
                    ring = null;
                },
            }));
        });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7c2ce39981a2dd9877d57af05db98697e1c20900/node_modules/rxjs/dist/esm/internal/operators/takeLast.js.map