import { createTransport } from '@sentry/core';
import { getIPC } from './ipc.js';

/**
 * Creates a Transport that passes envelopes to the Electron main process.
 */
function makeRendererTransport(options) {
    let ipc;
    return createTransport(options, async (request) => {
        // We delay getting the IPC interface until until there is a client where we can pull the IPC namespace from.
        if (!ipc) {
            ipc = getIPC();
        }
        ipc.sendEnvelope(request.body);
        // Since the main process handles sending of envelopes and rate limiting, we always return 200 OK to the renderers.
        return { statusCode: 200 };
    });
}

export { makeRendererTransport };//# sourceMappingURL=http://go/sourcemap/sourcemaps/7c2ce39981a2dd9877d57af05db98697e1c20900/node_modules/@sentry/electron/esm/renderer/transport.js.map
