import { ipcRenderer, contextBridge } from 'electron';
import { ipcChannelUtils } from '../common/ipc.js';

/**
 * This preload script may be used with sandbox mode enabled which means regular require is not available.
 */
/**
 * Hook up IPC to the window object and uses contextBridge if available.
 *
 * @param namespace An optional namespace to use for the IPC channels
 */
function hookupIpc(namespace = 'sentry-ipc') {
    const ipcUtil = ipcChannelUtils(namespace);
    // eslint-disable-next-line no-restricted-globals
    window.__SENTRY_IPC__ = window.__SENTRY_IPC__ || {};
    // eslint-disable-next-line no-restricted-globals
    if (window.__SENTRY_IPC__[ipcUtil.namespace]) {
        // eslint-disable-next-line no-console
        console.log('Sentry Electron preload has already been run');
    }
    else {
        const ipcObject = {
            sendRendererStart: () => ipcRenderer.send(ipcUtil.createKey('start')),
            sendScope: (scopeJson) => ipcRenderer.send(ipcUtil.createKey('scope'), scopeJson),
            sendEnvelope: (envelope) => ipcRenderer.send(ipcUtil.createKey('envelope'), envelope),
            sendStatus: (status) => ipcRenderer.send(ipcUtil.createKey('status'), status),
            sendStructuredLog: (log) => ipcRenderer.send(ipcUtil.createKey('structured-log'), log),
        };
        // eslint-disable-next-line no-restricted-globals
        window.__SENTRY_IPC__[ipcUtil.namespace] = ipcObject;
        // We attempt to use contextBridge if it's available
        if (contextBridge) {
            // This will fail if contextIsolation is not enabled
            try {
                // eslint-disable-next-line no-restricted-globals
                contextBridge.exposeInMainWorld('__SENTRY_IPC__', window.__SENTRY_IPC__);
            }
            catch (e) {
                //
            }
        }
    }
}

export { hookupIpc };//# sourceMappingURL=http://go/sourcemap/sourcemaps/7c2ce39981a2dd9877d57af05db98697e1c20900/node_modules/@sentry/electron/esm/preload/index.js.map
