/** Removes private properties from event before merging */
function removePrivateProperties(event) {
    // These contain recursive structures and are not meant to be serialized
    delete event.sdkProcessingMetadata?.capturedSpanScope;
    delete event.sdkProcessingMetadata?.capturedSpanIsolationScope;
    for (const span of event.spans || []) {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        delete span.spanRecorder;
    }
}
/** Merges Events with defaults */
function mergeEvents(defaults, event) {
    removePrivateProperties(event);
    const newEvent = {
        ...defaults,
        ...event,
        contexts: {
            ...defaults.contexts,
            ...event.contexts,
            app: {
                ...defaults.contexts?.app,
                ...event.contexts?.app,
            },
            device: {
                ...defaults.contexts?.device,
                ...event.contexts?.device,
            },
        },
        tags: {
            ...defaults.tags,
            ...event.tags,
        },
        sdk: {
            ...defaults.sdk,
            ...event.sdk,
        },
    };
    if (defaults.extra || event.extra) {
        newEvent.extra = {
            ...defaults.extra,
            ...event.extra,
        };
    }
    return newEvent;
}

export { mergeEvents };//# sourceMappingURL=http://go/sourcemap/sourcemaps/7c2ce39981a2dd9877d57af05db98697e1c20900/node_modules/@sentry/electron/esm/main/merge.js.map
