"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.arrayOrObject = exports.argsArgArrayOrObject = void 0;
const { isArray } = Array;
const { getPrototypeOf, prototype: objectProto, keys: getKeys } = Object;
function argsArgArrayOrObject(args) {
    if (args.length === 1) {
        const first = args[0];
        const result = arrayOrObject(first);
        if (result) {
            return result;
        }
    }
    return { args: args, keys: null };
}
exports.argsArgArrayOrObject = argsArgArrayOrObject;
function arrayOrObject(first) {
    if (isArray(first)) {
        return { args: first, keys: null };
    }
    if (isPOJO(first)) {
        const keys = getKeys(first);
        return {
            args: keys.map((key) => first[key]),
            keys,
        };
    }
    return null;
}
exports.arrayOrObject = arrayOrObject;
function isPOJO(obj) {
    return obj && typeof obj === 'object' && getPrototypeOf(obj) === objectProto;
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7b98dcb824ea96c9c62362a5e80dbf0d1aae4770/node_modules/rxjs/dist/cjs/internal/util/argsArgArrayOrObject.js.map