"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readZip = exports.extractFileAsBufferUsingStreams = exports.zipBuffers = void 0;
const archiver = __importStar(require("archiver"));
const fs = __importStar(require("node:fs"));
const node_stream_1 = require("node:stream");
const unzipper = __importStar(require("unzipper"));
const yauzl_1 = require("yauzl");
const zipBuffers = async (files) => {
    return new Promise((resolve, reject) => {
        const archive = archiver.default("zip", {
            zlib: { level: 9 },
        });
        const buffers = [];
        const writableStream = new node_stream_1.Writable({
            write(chunk, _, callback) {
                buffers.push(chunk);
                callback();
            },
        });
        writableStream.on("finish", () => {
            resolve(Buffer.concat(buffers));
        });
        archive.on("error", (err) => {
            reject(err);
        });
        archive.pipe(writableStream);
        files.forEach((file) => {
            archive.append(file.buffer, { name: file.filename });
        });
        archive.finalize();
    });
};
exports.zipBuffers = zipBuffers;
/**
 * Extract a specific file from a zip archive as a buffer using streams
 * @param zipFilePath The path to the zip file
 * @param fileName The name of the file to extract (e.g., ".signature.sig")
 * @returns A promise that resolves to a buffer containing the file contents
 */
const extractFileAsBufferUsingStreams = async (zipFilePath, fileName) => {
    return new Promise((resolve, reject) => {
        const fileBuffers = [];
        fs.createReadStream(zipFilePath)
            .pipe(unzipper.Parse())
            .on("entry", function (entry) {
            const entryPath = entry.path;
            if (entryPath === fileName) {
                entry.on("data", (chunk) => fileBuffers.push(chunk));
                entry.on("end", () => resolve(Buffer.concat(fileBuffers)));
            }
            else {
                entry.autodrain();
            }
        })
            .on("error", reject)
            .on("finish", () => {
            if (fileBuffers.length === 0) {
                reject(new Error(`File ${fileName} not found in ${zipFilePath}`));
            }
        });
    });
};
exports.extractFileAsBufferUsingStreams = extractFileAsBufferUsingStreams;
async function bufferStream(stream) {
    return await new Promise((resolve, reject) => {
        const buffers = [];
        stream.on("data", (buffer) => buffers.push(buffer));
        stream.once("error", reject);
        stream.once("end", () => resolve(Buffer.concat(buffers)));
    });
}
// Modified version of https://github.com/microsoft/vscode-vsce/blob/fd9a2627e29c031829e550b9bde2ce2282d99a3d/src/zip.ts#L15
// Changes: removed the `filter` parameter, renamed some variables and prevented returning lowercase keys
async function readZip(packagePath) {
    const zipfile = await new Promise((c, e) => (0, yauzl_1.open)(packagePath, { lazyEntries: true }, (err, zipfile) => (err ? e(err) : c(zipfile))));
    return await new Promise((resolve, reject) => {
        const result = new Map();
        zipfile.once("close", () => resolve(result));
        zipfile.readEntry();
        zipfile.on("entry", (entry) => {
            const name = entry.fileName;
            zipfile.openReadStream(entry, (err, stream) => {
                if (err) {
                    zipfile.close();
                    return reject(err);
                }
                bufferStream(stream).then((buffer) => {
                    result.set(name, buffer);
                    zipfile.readEntry();
                });
            });
        });
    });
}
exports.readZip = readZip;//# sourceMappingURL=http://go/sourcemap/sourcemaps/7b98dcb824ea96c9c62362a5e80dbf0d1aae4770/node_modules/node-ovsx-sign/lib/utils/zip.js.map