// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { generateUUID } from "./uuidUtils.common.js";
// NOTE: This could be undefined if not used in a secure context
const uuidFunction = typeof globalThis?.crypto?.randomUUID === "function"
    ? globalThis.crypto.randomUUID.bind(globalThis.crypto)
    : generateUUID;
/**
 * Generated Universally Unique Identifier
 *
 * @returns RFC4122 v4 UUID.
 */
export function randomUUID() {
    return uuidFunction();
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7b98dcb824ea96c9c62362a5e80dbf0d1aae4770/node_modules/@typespec/ts-http-runtime/dist/browser/util/uuidUtils-browser.mjs.map