/** Removes private properties from event before merging */
function removePrivateProperties(event) {
    // These contain recursive structures and are not meant to be serialized
    delete event.sdkProcessingMetadata?.capturedSpanScope;
    delete event.sdkProcessingMetadata?.capturedSpanIsolationScope;
    for (const span of event.spans || []) {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        delete span.spanRecorder;
    }
}
/** Merges Events with defaults */
function mergeEvents(defaults, event) {
    removePrivateProperties(event);
    const newEvent = {
        ...defaults,
        ...event,
        contexts: {
            ...defaults.contexts,
            ...event.contexts,
            app: {
                ...defaults.contexts?.app,
                ...event.contexts?.app,
            },
            device: {
                ...defaults.contexts?.device,
                ...event.contexts?.device,
            },
        },
        tags: {
            ...defaults.tags,
            ...event.tags,
        },
        sdk: {
            ...defaults.sdk,
            ...event.sdk,
        },
    };
    if (defaults.extra || event.extra) {
        newEvent.extra = {
            ...defaults.extra,
            ...event.extra,
        };
    }
    return newEvent;
}

export { mergeEvents };//# sourceMappingURL=http://go/sourcemap/sourcemaps/7b98dcb824ea96c9c62362a5e80dbf0d1aae4770/node_modules/@sentry/electron/esm/main/merge.js.map
