"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkSubscription = checkSubscription;
const logging_js_1 = require("./logging.js");
/**
 * @internal
 */
function checkSubscription(logger, subscription) {
    if (!subscription.match(/^[0-9a-zA-Z-._ ]+$/)) {
        const error = new Error(`Subscription '${subscription}' contains invalid characters. If this is the name of a subscription, use ` +
            `its ID instead. You can locate your subscription by following the instructions listed here: ` +
            `https://learn.microsoft.com/azure/azure-portal/get-subscription-tenant-id`);
        logger.info((0, logging_js_1.formatError)("", error));
        throw error;
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7b98dcb824ea96c9c62362a5e80dbf0d1aae4770/node_modules/@azure/identity/dist/commonjs/util/subscriptionUtils.js.map