import { Observable, from, operate } from '../Observable.js';
import { noop } from '../util/noop.js';
export function sample(notifier) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        let lastValue = null;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                lastValue = value;
            },
        }));
        from(notifier).subscribe(operate({
            destination,
            next: () => {
                if (hasValue) {
                    hasValue = false;
                    const value = lastValue;
                    lastValue = null;
                    destination.next(value);
                }
            },
            complete: noop,
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7b98dcb824ea96c9c62362a5e80dbf0d1aae4770/node_modules/rxjs/dist/esm/internal/operators/sample.js.map