export class DelegateBackoff {
    /**
     * Backoff that delegates to a user-provided function. The function takes
     * the backoff context, and can optionally take (and return) a state value
     * that will be passed into subsequent backoff requests.
     */
    constructor(fn) {
        this.fn = fn;
    }
    /**
     * @inheritdoc
     */
    next(context) {
        return instance(this.fn).next(context);
    }
}
const instance = (fn, state, current = 0) => ({
    duration: current,
    next(context) {
        const result = fn(context, state);
        return typeof result === 'number'
            ? instance(fn, state, result)
            : instance(fn, result.state, result.delay);
    },
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/7b98dcb824ea96c9c62362a5e80dbf0d1aae4770/node_modules/cockatiel/dist/esm/backoff/DelegateBackoff.js.map