import { neverAbortedSignal } from './common/abort';
import { ExecuteWrapper, returnOrThrow } from './common/Executor';
/**
 * A no-op policy, useful for unit tests and stubs.
 */
export class NoopPolicy {
    constructor() {
        this.executor = new ExecuteWrapper();
        this.onSuccess = this.executor.onSuccess;
        this.onFailure = this.executor.onFailure;
    }
    async execute(fn, signal = neverAbortedSignal) {
        return returnOrThrow(await this.executor.invoke(fn, { signal }));
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7b98dcb824ea96c9c62362a5e80dbf0d1aae4770/node_modules/cockatiel/dist/esm/NoopPolicy.js.map