"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstantBackoff = void 0;
class ConstantBackoff {
    /**
     * Backoff that returns a constant interval.
     */
    constructor(interval) {
        this.interval = interval;
    }
    /**
     * @inheritdoc
     */
    next() {
        return instance(this.interval);
    }
}
exports.ConstantBackoff = ConstantBackoff;
const instance = (interval) => ({
    duration: interval,
    next() {
        return this;
    },
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/7b98dcb824ea96c9c62362a5e80dbf0d1aae4770/node_modules/cockatiel/dist/backoff/ConstantBackoff.js.map