import { defineIntegration, captureException, flush, SEMANTIC_ATTRIBUTE_SENTRY_OP } from '@sentry/core';
import { generateInstrumentOnce, addOriginToSpan } from '@sentry/node-core';
import { FirebaseInstrumentation } from './otel/firebaseInstrumentation.js';

const INTEGRATION_NAME = 'Firebase';

const config = {
  firestoreSpanCreationHook: span => {
    addOriginToSpan(span, 'auto.firebase.otel.firestore');

    span.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_OP, 'db.query');
  },
  functions: {
    requestHook: span => {
      addOriginToSpan(span, 'auto.firebase.otel.functions');

      span.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_OP, 'http.request');
    },
    errorHook: async (_, error) => {
      if (error) {
        captureException(error, {
          mechanism: {
            type: 'auto.firebase.otel.functions',
            handled: false,
          },
        });
        await flush(2000);
      }
    },
  },
};

const instrumentFirebase = generateInstrumentOnce(INTEGRATION_NAME, () => new FirebaseInstrumentation(config));

const _firebaseIntegration = (() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentFirebase();
    },
  };
}) ;

const firebaseIntegration = defineIntegration(_firebaseIntegration);

export { firebaseIntegration, instrumentFirebase };//# sourceMappingURL=http://go/sourcemap/sourcemaps/77af5775de140fced9aeb1a50e372883667d6810/node_modules/@sentry/node/build/esm/integrations/tracing/firebase/firebase.js.map
