export const intervalProvider = {
    setInterval(handler, timeout, ...args) {
        const { delegate } = intervalProvider;
        if (delegate?.setInterval) {
            return delegate.setInterval(handler, timeout, ...args);
        }
        return setInterval(handler, timeout, ...args);
    },
    clearInterval(handle) {
        const { delegate } = intervalProvider;
        return (delegate?.clearInterval || clearInterval)(handle);
    },
    delegate: undefined,
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/77af5775de140fced9aeb1a50e372883667d6810/node_modules/rxjs/dist/esm/internal/scheduler/intervalProvider.js.map