import { Observable, operate } from '../Observable.js';
export function every(predicate, thisArg) {
    return (source) => new Observable((destination) => {
        let index = 0;
        source.subscribe(operate({
            destination,
            next: (value) => {
                if (!predicate.call(thisArg, value, index++, source)) {
                    destination.next(false);
                    destination.complete();
                }
            },
            complete: () => {
                destination.next(true);
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7584ea888f7eb7bf76c9873a8f71b28f034a9820/node_modules/rxjs/dist/esm/internal/operators/every.js.map