import { from } from '../Observable.js';
import { mergeAll } from '../operators/mergeAll.js';
import { EMPTY } from './empty.js';
import { popNumber, popScheduler } from '../util/args.js';
import { scheduled } from '../scheduled/scheduled.js';
export function merge(...args) {
    const scheduler = popScheduler(args);
    const concurrent = popNumber(args, Infinity);
    const sources = args;
    return !sources.length
        ?
            EMPTY
        : sources.length === 1
            ?
                from(sources[0])
            :
                mergeAll(concurrent)(scheduler ? scheduled(sources, scheduler) : from(sources));
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7584ea888f7eb7bf76c9873a8f71b28f034a9820/node_modules/rxjs/dist/esm/internal/observable/merge.js.map