"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFind = exports.find = void 0;
const Observable_js_1 = require("../Observable.js");
function find(predicate) {
    return (source) => new Observable_js_1.Observable((subscriber) => createFind(predicate, 'value', source, subscriber));
}
exports.find = find;
function createFind(predicate, emit, source, destination) {
    const findIndex = emit === 'index';
    let index = 0;
    source.subscribe((0, Observable_js_1.operate)({
        destination,
        next: (value) => {
            const i = index++;
            if (predicate(value, i, source)) {
                destination.next(findIndex ? i : value);
                destination.complete();
            }
        },
        complete: () => {
            destination.next(findIndex ? -1 : undefined);
            destination.complete();
        },
    }));
}
exports.createFind = createFind;//# sourceMappingURL=http://go/sourcemap/sourcemaps/7584ea888f7eb7bf76c9873a8f71b28f034a9820/node_modules/rxjs/dist/cjs/internal/operators/find.js.map