Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

let cachedDebuggerEnabled;

/**
 * Was the debugger enabled when this function was first called?
 */
async function isDebuggerEnabled() {
  if (cachedDebuggerEnabled === undefined) {
    try {
      // Node can be built without inspector support
      const inspector = await import('node:inspector');
      cachedDebuggerEnabled = !!inspector.url();
    } catch {
      cachedDebuggerEnabled = false;
    }
  }

  return cachedDebuggerEnabled;
}

exports.isDebuggerEnabled = isDebuggerEnabled;//# sourceMappingURL=http://go/sourcemap/sourcemaps/7584ea888f7eb7bf76c9873a8f71b28f034a9820/node_modules/@sentry/node-core/build/cjs/utils/debug.js.map
