import { Observable, from, operate } from '../Observable.js';
export function switchMap(project) {
    return (source) => new Observable((destination) => {
        let innerSubscriber = null;
        let index = 0;
        let isComplete = false;
        const checkComplete = () => isComplete && !innerSubscriber && destination.complete();
        source.subscribe(operate({
            destination,
            next: (value) => {
                innerSubscriber?.unsubscribe();
                const outerIndex = index++;
                from(project(value, outerIndex)).subscribe((innerSubscriber = operate({
                    destination,
                    complete: () => {
                        innerSubscriber = null;
                        checkComplete();
                    },
                })));
            },
            complete: () => {
                isComplete = true;
                checkComplete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7584ea888f7eb7bf76c9873a8f71b28f034a9820/node_modules/rxjs/dist/esm/internal/operators/switchMap.js.map