const browser = require('@sentry/browser');
const core = require('@sentry/core');

const STACKTRACE_FRAME_LIMIT = 50;
const [, chrome] = browser.chromeStackLineParser;
const [, node] = core.nodeStackLineParser();
/**
 * A stack parser than combines Chrome and node.js parsers to give the best results even when nodeIntegration = true
 */
const electronRendererStackParser = (stack, skipFirst = 0) => {
    const frames = [];
    for (const line of stack.split('\n').slice(skipFirst)) {
        const chromeFrame = chrome(line);
        const nodeFrame = node(line);
        // We favour the chrome parser unless in_app == false
        if (chromeFrame && nodeFrame?.in_app !== false) {
            frames.push(chromeFrame);
        }
        else if (nodeFrame) {
            if (nodeFrame.module === undefined) {
                delete nodeFrame.module;
            }
            frames.push(nodeFrame);
        }
        if (frames.length >= STACKTRACE_FRAME_LIMIT) {
            break;
        }
    }
    return core.stripSentryFramesAndReverse(frames);
};

exports.electronRendererStackParser = electronRendererStackParser;//# sourceMappingURL=http://go/sourcemap/sourcemaps/7584ea888f7eb7bf76c9873a8f71b28f034a9820/node_modules/@sentry/electron/renderer/stack-parse.js.map
