import { Observable, operate, isFunction } from '../Observable.js';
import { identity } from '../util/identity.js';
export function tap(observerOrNext) {
    const tapObserver = isFunction(observerOrNext) ? { next: observerOrNext } : observerOrNext;
    return tapObserver
        ? (source) => new Observable((destination) => {
            tapObserver.subscribe?.();
            let isUnsub = true;
            source.subscribe(operate({
                destination,
                next: (value) => {
                    tapObserver.next?.(value);
                    destination.next(value);
                },
                error: (err) => {
                    isUnsub = false;
                    tapObserver.error?.(err);
                    destination.error(err);
                },
                complete: () => {
                    isUnsub = false;
                    tapObserver.complete?.();
                    destination.complete();
                },
                finalize: () => {
                    if (isUnsub) {
                        tapObserver.unsubscribe?.();
                    }
                    tapObserver.finalize?.();
                },
            }));
        })
        :
            identity;
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7584ea888f7eb7bf76c9873a8f71b28f034a9820/node_modules/rxjs/dist/esm/internal/operators/tap.js.map