import { EMPTY } from '../observable/empty.js';
import { Observable, operate } from '../Observable.js';
export function take(count) {
    return count <= 0
        ?
            () => EMPTY
        : (source) => new Observable((destination) => {
            let seen = 0;
            const operatorSubscriber = operate({
                destination,
                next: (value) => {
                    if (++seen < count) {
                        destination.next(value);
                    }
                    else {
                        operatorSubscriber.unsubscribe();
                        destination.next(value);
                        destination.complete();
                    }
                },
            });
            source.subscribe(operatorSubscriber);
        });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/7584ea888f7eb7bf76c9873a8f71b28f034a9820/node_modules/rxjs/dist/esm/internal/operators/take.js.map