import { Observable, operate } from '../Observable.js';
export function takeWhile(predicate, inclusive = false) {
    return (source) => new Observable((destination) => {
        let index = 0;
        const operatorSubscriber = operate({
            destination,
            next: (value) => {
                if (predicate(value, index++)) {
                    destination.next(value);
                }
                else {
                    operatorSubscriber.unsubscribe();
                    if (inclusive) {
                        destination.next(value);
                    }
                    destination.complete();
                }
            },
        });
        source.subscribe(operatorSubscriber);
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/6e2aa94f015240b4d1c7e5410b89593f9f53fef0/node_modules/rxjs/dist/esm/internal/operators/takeWhile.js.map