import { Observable, operate, from } from '../Observable.js';
import { noop } from '../util/noop.js';
export function skipUntil(notifier) {
    return (source) => new Observable((destination) => {
        let taking = false;
        const skipSubscriber = operate({
            destination,
            next: () => {
                skipSubscriber?.unsubscribe();
                taking = true;
            },
            complete: noop,
        });
        from(notifier).subscribe(skipSubscriber);
        source.subscribe(operate({ destination, next: (value) => taking && destination.next(value) }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/6e2aa94f015240b4d1c7e5410b89593f9f53fef0/node_modules/rxjs/dist/esm/internal/operators/skipUntil.js.map