"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.animationFrameProvider = void 0;
const Observable_js_1 = require("../Observable.js");
exports.animationFrameProvider = {
    schedule(callback) {
        let request = requestAnimationFrame;
        let cancel = cancelAnimationFrame;
        const { delegate } = exports.animationFrameProvider;
        if (delegate) {
            request = delegate.requestAnimationFrame;
            cancel = delegate.cancelAnimationFrame;
        }
        const handle = request((timestamp) => {
            cancel = undefined;
            callback(timestamp);
        });
        return new Observable_js_1.Subscription(() => cancel?.(handle));
    },
    requestAnimationFrame(...args) {
        const { delegate } = exports.animationFrameProvider;
        return (delegate?.requestAnimationFrame || requestAnimationFrame)(...args);
    },
    cancelAnimationFrame(...args) {
        const { delegate } = exports.animationFrameProvider;
        return (delegate?.cancelAnimationFrame || cancelAnimationFrame)(...args);
    },
    delegate: undefined,
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/6e2aa94f015240b4d1c7e5410b89593f9f53fef0/node_modules/rxjs/dist/cjs/internal/scheduler/animationFrameProvider.js.map