function addHeader(responseHeaders = {}, name, value) {
    if (responseHeaders[name]) {
        const existing = responseHeaders[name];
        if (Array.isArray(existing)) {
            existing.push(value);
        }
        else {
            responseHeaders[name] = [existing, value];
        }
    }
    else {
        responseHeaders[name] = value;
    }
    return { responseHeaders };
}
/**
 * Adds a header to a session's web request
 */
function addHeaderToSession(sesh, header, value) {
    sesh.webRequest.onHeadersReceived((details, callback) => {
        callback(addHeader(details.responseHeaders, header, value));
    });
}

export { addHeaderToSession };//# sourceMappingURL=http://go/sourcemap/sourcemaps/6e2aa94f015240b4d1c7e5410b89593f9f53fef0/node_modules/@sentry/electron/esm/main/header-injection.js.map
