import { Observable } from '../Observable.js';
import { executeSchedule } from '../util/executeSchedule.js';
export function scheduleAsyncIterable(input, scheduler) {
    if (!input) {
        throw new Error('Iterable cannot be null');
    }
    return new Observable((subscriber) => {
        executeSchedule(subscriber, scheduler, () => {
            const iterator = input[Symbol.asyncIterator]();
            executeSchedule(subscriber, scheduler, () => {
                iterator.next().then((result) => {
                    if (result.done) {
                        subscriber.complete();
                    }
                    else {
                        subscriber.next(result.value);
                    }
                });
            }, 0, true);
        });
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/6e2aa94f015240b4d1c7e5410b89593f9f53fef0/node_modules/rxjs/dist/esm/internal/scheduled/scheduleAsyncIterable.js.map