import { Observable, from, operate } from '../Observable.js';
import { noop } from '../util/noop.js';
export function sample(notifier) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        let lastValue = null;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                lastValue = value;
            },
        }));
        from(notifier).subscribe(operate({
            destination,
            next: () => {
                if (hasValue) {
                    hasValue = false;
                    const value = lastValue;
                    lastValue = null;
                    destination.next(value);
                }
            },
            complete: noop,
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/6e2aa94f015240b4d1c7e5410b89593f9f53fef0/node_modules/rxjs/dist/esm/internal/operators/sample.js.map