"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.switchScan = void 0;
const switchMap_js_1 = require("./switchMap.js");
const Observable_js_1 = require("../Observable.js");
function switchScan(accumulator, seed) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let state = seed;
        (0, switchMap_js_1.switchMap)((value, index) => accumulator(state, value, index))(source).subscribe((0, Observable_js_1.operate)({
            destination,
            next: (innerValue) => {
                state = innerValue;
                destination.next(innerValue);
            },
        }));
        return () => {
            state = null;
        };
    });
}
exports.switchScan = switchScan;//# sourceMappingURL=http://go/sourcemap/sourcemaps/6e2aa94f015240b4d1c7e5410b89593f9f53fef0/node_modules/rxjs/dist/cjs/internal/operators/switchScan.js.map