"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.connect = void 0;
const Observable_js_1 = require("../Observable.js");
const Subject_js_1 = require("../Subject.js");
const fromSubscribable_js_1 = require("../observable/fromSubscribable.js");
const DEFAULT_CONFIG = {
    connector: () => new Subject_js_1.Subject(),
};
function connect(selector, config = DEFAULT_CONFIG) {
    const { connector } = config;
    return (source) => new Observable_js_1.Observable((subscriber) => {
        const subject = connector();
        (0, Observable_js_1.from)(selector((0, fromSubscribable_js_1.fromSubscribable)(subject))).subscribe(subscriber);
        subscriber.add(source.subscribe(subject));
    });
}
exports.connect = connect;//# sourceMappingURL=http://go/sourcemap/sourcemaps/6e2aa94f015240b4d1c7e5410b89593f9f53fef0/node_modules/rxjs/dist/cjs/internal/operators/connect.js.map