"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.takeUntil = void 0;
const Observable_js_1 = require("../Observable.js");
const noop_js_1 = require("../util/noop.js");
function takeUntil(notifier) {
    return (source) => new Observable_js_1.Observable((destination) => {
        (0, Observable_js_1.from)(notifier).subscribe((0, Observable_js_1.operate)({ destination, next: () => destination.complete(), complete: noop_js_1.noop }));
        !destination.closed && source.subscribe(destination);
    });
}
exports.takeUntil = takeUntil;//# sourceMappingURL=http://go/sourcemap/sourcemaps/6b030be1a256f7464cbd98e48627a802a4831bf0/node_modules/rxjs/dist/cjs/internal/operators/takeUntil.js.map