import { defineIntegration } from '@sentry/core';
import { generateInstrumentOnce } from '../../otel/instrument.js';
import { SentryNodeFetchInstrumentation } from './SentryNodeFetchInstrumentation.js';

const INTEGRATION_NAME = 'NodeFetch';

const instrumentSentryNodeFetch = generateInstrumentOnce(
  `${INTEGRATION_NAME}.sentry`,
  SentryNodeFetchInstrumentation,
  (options) => {
    return options;
  },
);

const _nativeNodeFetchIntegration = ((options = {}) => {
  return {
    name: 'NodeFetch',
    setupOnce() {
      instrumentSentryNodeFetch(options);
    },
  };
}) ;

const nativeNodeFetchIntegration = defineIntegration(_nativeNodeFetchIntegration);

export { nativeNodeFetchIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/6b030be1a256f7464cbd98e48627a802a4831bf0/node_modules/@sentry/node-core/build/esm/integrations/node-fetch/index.js.map
