import { Observable, operate } from '../Observable.js';
export function defaultIfEmpty(defaultValue) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => {
                if (!hasValue) {
                    destination.next(defaultValue);
                }
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/68e0a0385b87408d050869ea543e3778ad53f780/node_modules/rxjs/dist/esm/internal/operators/defaultIfEmpty.js.map