const core = require('@sentry/core');
const sessions = require('../sessions.js');

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = core.defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            sessions.startSession(!!options.sendOnCreate);
            sessions.endSessionOnExit();
        },
    };
});

exports.mainProcessSessionIntegration = mainProcessSessionIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/68e0a0385b87408d050869ea543e3778ad53f780/node_modules/@sentry/electron/main/integrations/main-process-session.js.map
