"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BehaviorSubject = void 0;
const Subject_js_1 = require("./Subject.js");
class BehaviorSubject extends Subject_js_1.Subject {
    _value;
    constructor(_value) {
        super();
        this._value = _value;
    }
    get value() {
        return this.getValue();
    }
    _subscribe(subscriber) {
        const subscription = super._subscribe(subscriber);
        !subscription.closed && subscriber.next(this._value);
        return subscription;
    }
    getValue() {
        const { hasError, thrownError, _value } = this;
        if (hasError) {
            throw thrownError;
        }
        return _value;
    }
    next(value) {
        super.next((this._value = value));
    }
}
exports.BehaviorSubject = BehaviorSubject;//# sourceMappingURL=http://go/sourcemap/sourcemaps/6757269838ae9ac4caaa2be13f396fdfbcf1f9a0/node_modules/rxjs/dist/cjs/internal/BehaviorSubject.js.map